package w83a.w83aOperacionesPaso.w83aResultados;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83a.w83aBeans.W83aResultadosBean;
import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aUtilidades.W83aUtilidadesComunes;
import w83a.w83aUtilidades.W83aUtilidadesExcel;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83aTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83aTablaDelegConvDetCentroExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83aDelegConvenio.xls";
		InputStream inputStream = W83aTablaDelegConvDetCentroExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		Comparator comparador=Collections.reverseOrder();
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        Map general = (HashMap)contexto.get("w83aMapResultadosBean");
        Map convenios=(TreeMap)general.get("convenios");
        W83aResultadosBean resultadoBean = (W83aResultadosBean)contexto.get("w83aResultadosBean");
        
        W83aUtilidadesExcel excel = new W83aUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83aUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83aUsuarioXLNetsBean usuario = (W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
             
        String provincia = usuario.getCodTerritorioDelegacion();       
        Double porcentajeFiltro=new Double(0.0);
        if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())){
        	String porc=resultadoBean.getPorcentaje().replace(',','.');
    		porcentajeFiltro = new Double(porc);
        }
        HSSFRow row;
        HSSFCell cell;
        HSSFCell cell2;
        HSSFCell cell3;
        HSSFCell cell4;
        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)5);
        
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)10); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        
        
        if(W83aClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83aClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_es",idioma));
        }else if(W83aClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83aClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	
        
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)10); 
        cell.setCellValue(tituloImagenEs.toString());
        
        row = sheet.getRow((short)10); 
        cell = row.createCell((short)6); 
        
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaHistorico())){
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));
    	}		
       
        
        row = sheet.getRow((short)11); 
        
        HSSFCell cell6;
        HSSFCell cell5;       

        cell = row.getCell((short)2); 
        if(StringUtils.isNotEmpty(resultadoBean.getDescTerritorio())){
        	cell.setCellValue(resultadoBean.getDescTerritorio().toUpperCase());
        }
       
        if(!W83aClsConstantes.VACIO.equals(cell.getStringCellValue())){
	 		sheet.addMergedRegion(new Region(11,Short.parseShort("2"),11,Short.parseShort("3")));//NOPMD
		}
        cell = row.getCell((short)3); 
        
        
        cell = row.getCell((short)5); 
        if(StringUtils.isNotEmpty(resultadoBean.getSectorTxt())){
        	cell.setCellValue(resultadoBean.getSectorTxt());
        }
        if(!W83aClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(11,Short.parseShort("5"),11,Short.parseShort("12")));//NOPMD
		}
        cell = row.getCell((short)6); 
        cell = row.getCell((short)7); 
        cell = row.getCell((short)8); 
        cell = row.getCell((short)9); 
        cell = row.getCell((short)10); 
        cell = row.getCell((short)11); 
        cell = row.getCell((short)12); 
      
        
        
        row = sheet.getRow((short)12); 
        
        cell = row.getCell((short)3); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionDesde())){
        	cell.setCellValue(resultadoBean.getFechaEleccionDesde());
        }
       
        cell = row.getCell((short)6); 
        
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionHasta())){
        	cell.setCellValue(resultadoBean.getFechaEleccionHasta());
        }
        if(!W83aClsConstantes.VACIO.equals(cell.getStringCellValue())){
	 		sheet.addMergedRegion(new Region(12,Short.parseShort("6"),12,Short.parseShort("7")));//NOPMD
	 		cell = row.createCell((short)7); 
		}
        
        cell = row.getCell((short)14); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaRegistroDefinitivo())){
        	cell.setCellValue(resultadoBean.getFechaRegistroDefinitivo());
        }
        
        if(resultadoBean.getPorcentaje()!=null && !"".equals(resultadoBean.getPorcentaje())){
	        cell = row.createCell((short)16); 
	        cell.setCellValue(porcentajeFiltro+"%");
	       
        }else{
        	 cell = row.createCell((short)15); 
        	 cell.setCellValue("");
        }
        
        int contador=14;
        
        Map mapConveniosOrdenado = new TreeMap(convenios);
        Set ref = mapConveniosOrdenado.keySet();
        
        String[]valores;
        String convenio;
        String centro;
        String acta;
        
        int electores=0;
        int numvotos=0;
        
        //Totales convenio
        int totalelectores;
        int totalvotos;
        int totaldelegados;
        List sindicatossector=new ArrayList();
        
        //Totales territorio
        int totalelectoresterrit=0;
        int numvotosterrit=0;
        int totaldelegadosterrit=0;
        List sindicatossectorterrit=new ArrayList();
        int lineascuerpo=0;
        int pag=0;
	   for( Iterator it = ref.iterator(); it.hasNext();) {
		    lineascuerpo=0;
		    pag=pag+1;
	        totalelectores=0;
	        totalvotos=0;
	        numvotos=0;
	        totaldelegados=0;
	        totalelectores=0;
	        sindicatossector=new ArrayList();//NOPMD
		    convenio=(String)it.next();
        	contador=contador+2;
        	lineascuerpo=lineascuerpo+2;
        	row = sheet.createRow((short)contador); 
            cell = row.createCell((short)1);
            cell2 = row.createCell((short)2);
            cell3 = row.createCell((short)3);
            cell4 = row.createCell((short)4);
            cell5 = row.createCell((short)5);
            cell6 = row.createCell((short)6);
           
            sheet.addMergedRegion(new Region((short)contador,(short)1,(short)contador,(short)11));//NOPMD
        	valores=convenio.split("\\|");
        	//Descripcin convenio
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.preavisos.labels.convenio",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.preavisos.labels.convenio",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": "+Integer.parseInt(valores[0])+"-"+valores[1]);
        	//Cabecera
        	contador=contador+1;
        	row = sheet.createRow((short)contador); 
        	cell = row.createCell((short)13);
        	cell.setCellStyle(excel.styleTextoImparCentrado);
        	cell2 = row.createCell((short)14);
        	cell2.setCellStyle(excel.styleTextoImparCentrado);
            cell3 = row.createCell((short)15);
            cell3.setCellStyle(excel.styleTextoImparCentrado);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.centralsindical",W83aClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.centralsindical",W83aClsConstantes.CONSTANTE_CASTELLANO));
            row = sheet.createRow((short)contador+1); 
            cell = row.createCell((short)13);
            cell.setCellStyle(styleTextoImparCentrado(excel));
            sheet.addMergedRegion(new Region((short)contador,(short)13,(short)contador+1,(short)15));//NOPMD
            row = sheet.createRow((short)contador); 
            cell = row.createCell((short)16);
            cell.setCellStyle(excel.styleTextoImparCentrado);
            cell2 = row.createCell((short)17);
            cell2.setCellStyle(excel.styleTextoImparCentrado);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.menu.Delegados",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.menu.Delegados",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            sheet.addMergedRegion(new Region((short)contador,(short)16,(short)contador+1,(short)17));//NOPMD
            contador=contador+1;
            row = sheet.createRow((short)contador); 
            cell = row.createCell((short)14);
            cell.setCellStyle(excel.styleBordeIzda);
            cell2 = row.createCell((short)15);
            cell2.setCellStyle(excel.styleBordeDcha);
            cell3 = row.createCell((short)16);
            cell.setCellStyle(excel.styleTextoImpar);
            cell4 = row.createCell((short)17);
            cell4.setCellStyle(excel.styleBordeDcha);
        	
        	contador=contador+1;
        	row = sheet.createRow((short)contador); 
        	cell = row.createCell((short)0);
        	cell2 = row.createCell((short)1);
        	cell3 = row.createCell((short)2);
        	cell4 = row.createCell((short)3);
        	cell5 = row.createCell((short)4);
        	cell6 = row.createCell((short)5);
        	sheet.addMergedRegion(new Region((short)contador,(short)0,(short)contador,(short)5));//NOPMD
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nombrecentro",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nombrecentro",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell2.setCellStyle(styleTextoImparCentrado(excel));
            cell3.setCellStyle(styleTextoImparCentrado(excel));
            cell4.setCellStyle(styleTextoImparCentrado(excel));
            cell5.setCellStyle(styleTextoImparCentrado(excel));
            cell6.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)6);
            cell2 = row.createCell((short)7);
            cell3 = row.createCell((short)8);
            sheet.addMergedRegion(new Region((short)contador,(short)6,(short)contador,(short)8));//NOPMD
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.registroDefinitivo.numEntrada",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.registroDefinitivo.numEntrada",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell2.setCellStyle(styleTextoImparCentrado(excel));
            cell3.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)9);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.elect",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.elect",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)10);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.votant",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.votant",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)11);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.deleg",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.deleg",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)12);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.partic",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.partic",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)13);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.cod",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.cod",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)14);
            cell2 = row.createCell((short)15);
            sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15));//NOPMD
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.sindicatos.siglas",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.sindicatos.siglas",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell2.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)16);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.num",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.num",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)17);
            cell.setCellValue("%");
            cell.setCellStyle(styleTextoImparCentrado(excel));
            int numdelegados;
            int filadeleg;
            lineascuerpo=lineascuerpo+3;
            //Descripcin convenio
            Map mapActasOrdenado = new TreeMap((Map)mapConveniosOrdenado.get(convenio));//NOPMD
            Set refc = mapActasOrdenado.keySet();
        	for(Iterator itconv = refc.iterator(); itconv.hasNext();) { 
        		centro=(String)itconv.next();
        		numdelegados=0;
                filadeleg=0;
                contador=contador+1;
                lineascuerpo=lineascuerpo+1;
                row = sheet.createRow((short)contador); 
                cell = row.createCell((short)0);
            	valores=centro.split("\\|");
            	if(StringUtils.isNotEmpty(valores[1])){
            		cell.setCellValue(valores[1]);
            	}
            	numdelegados=0;
            	acta=(String)valores[0];
            	String actater="";
            	if (acta.startsWith("1")){
            		actater="0"+acta;
            	}
            	else{
            		actater=acta;
            	}
            	cell = row.createCell((short)6);
            	cell2 = row.createCell((short)7);
            	cell3 = row.createCell((short)8);
            	sheet.addMergedRegion(new Region((short)contador,(short)6,(short)contador,(short)8));//NOPMD
            	StringBuffer sb=new StringBuffer(W83aClsConstantes.SEIS);//NOPMD
            	String valor=W83aUtilidadesComunes.rellenarCeros(actater.substring(6,12));
            	sb.append(valor);
                cell.setCellValue(Integer.parseInt(actater.substring(0,2))+"/"+actater.substring(2,6)+"/"+sb.toString());
                cell.setCellStyle(styleCentrado(excel));
                cell2.setCellStyle(styleCentrado(excel));
                String datos=(String)((List)mapActasOrdenado.get(centro)).get(((List)mapActasOrdenado.get(centro)).size()-1);
                valores=datos.split("\\|");
                cell = row.createCell((short)9);
                cell.setCellStyle(styleDerechaNumeroFormateado(excel));
                if(StringUtils.isNotEmpty(valores[0])){
                	cell.setCellValue(W83aUtilidades.numero(valores[0]));
                }
                cell = row.createCell((short)10);
                cell.setCellStyle(styleDerechaNumeroFormateado(excel));
                if(StringUtils.isNotEmpty(valores[1])){
                	cell.setCellValue(W83aUtilidades.numero(valores[1]));
                }
                electores=Integer.parseInt(valores[0]);
                totalelectores=totalelectores+electores;
                totalelectoresterrit=totalelectoresterrit+electores;
                numvotos=Integer.parseInt(valores[1]);
                totalvotos=totalvotos+numvotos;
                numvotosterrit=numvotosterrit+numvotos;
                filadeleg=contador;
                for (int i=0;i<((List)mapActasOrdenado.get(centro)).size()-1;i++){
                	valores=((String)((List)mapActasOrdenado.get(centro)).get(i)).split("\\|");
                	numdelegados=numdelegados+Integer.parseInt(valores[0]);//
                }
                boolean otros=false;
                int delegados=0;
                for (int i=0;i<((List)mapActasOrdenado.get(centro)).size()-1;i++){
                	sindicatossector=W83aUtilidadesComunes.listaSindicatos(sindicatossector, (String)((List)mapActasOrdenado.get(centro)).get(i));
                	sindicatossectorterrit=W83aUtilidadesComunes.listaSindicatos(sindicatossectorterrit, (String)((List)mapActasOrdenado.get(centro)).get(i));
                	valores=((String)((List)mapActasOrdenado.get(centro)).get(i)).split("\\|");
                	//debemos mirar  si el % no supera el que hemos puesto, para ponerlo en otros
                	if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83aUtilidades.porcentaje(Integer.parseInt(valores[0]),numdelegados)*100<porcentajeFiltro.floatValue()){//
                		delegados=delegados+Integer.parseInt(valores[0]);//
                		otros=true;
                	}
                	else{
	                	cell = row.createCell((short)13);
	                	cell.setCellStyle(styleCentrado(excel));
	                	if ("-1".equals(valores[2])){//
	                		cell.setCellValue("");
	                	}
	                	else{
	                		if(StringUtils.isNotEmpty(valores[2])){
	                			cell.setCellValue(W83aUtilidades.numero(valores[2]));//
	                		}
	                	}
	                    cell = row.createCell((short)14);
	                    cell2 = row.createCell((short)15);	                    	
	                    sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15));//NOPMD
	                    if ("-1".equals(valores[2])){//
	                    	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.centralnoespecificada",idioma).toUpperCase());
	                	}else if ("null".equals(valores[1])){
	                		cell.setCellValue("");
	                	}
	                	else{
	                		if(StringUtils.isNotEmpty(valores[1])){
	                			cell.setCellValue(valores[1]);
	                		}
	                	}
	                    cell = row.createCell((short)16);
	                    cell.setCellStyle(styleCentrado(excel));
	                    if(StringUtils.isNotEmpty(valores[0])){
	                    	cell.setCellValue(W83aUtilidades.numero(valores[0]));//
	                    }
	                    totaldelegados=totaldelegados+Integer.parseInt(valores[0]);//
	                    totaldelegadosterrit=totaldelegadosterrit+Integer.parseInt(valores[0]);//
	                    cell = row.createCell((short)17);
	                    	
	                    cell.setCellStyle(stylePorcentajesDcha(excel));
	                    cell.setCellValue(calcularporcentaje(Integer.parseInt(valores[0]),numdelegados));//
	                    contador=contador+1;
	                    lineascuerpo=lineascuerpo+1;
	                    row = sheet.createRow((short)contador); 
                		}
                	}
                    if(otros){
                		totaldelegados=totaldelegados+delegados;
                		totaldelegadosterrit=totaldelegadosterrit+delegados;
                		//metemos la linea de otros
                		cell = row.createCell((short)14);
                    	cell2 = row.createCell((short)15);
                    	sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15)); //NOPMD
                		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase());
                		
                		cell = row.createCell((short)16);
                		cell.setCellStyle(styleCentrado(excel));
                		cell.setCellValue(delegados);
                		
                		cell = row.createCell((short)17);
                    	cell.setCellValue(W83aUtilidades.porcentaje(delegados,numdelegados));
                    	cell.setCellStyle(stylePorcentajesDcha(excel));
                		
                		
                		contador=contador+1;
                		lineascuerpo=lineascuerpo+1;
                    	row = sheet.createRow((short)contador);
                		
                	}
                    row = sheet.createRow((short)filadeleg);
                	cell = row.createCell((short)11);
                	cell.setCellStyle(styleDerechaNumeroFormateado(excel));
                	cell.setCellValue(numdelegados);
                	cell = row.createCell((short)12);
                	cell.setCellStyle(excel.stylePorcentajesDcha);
                	cell.setCellValue(calcularporcentaje(numvotos,electores));           	
        	}
           contador=contador+1;
           lineascuerpo=lineascuerpo+1;
     	   row = sheet.createRow((short)contador);
     	   cell = row.createCell((short)0);
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)1);
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)2);
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)3);
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)4);
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)5);
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)6);
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)7);
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)8);
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)9);
     	   
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)10);
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)11);
     	   
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)12);
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)13);
     	   
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)14);
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)15);
     	   
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)16);
     	   cell.setCellStyle(bordeArriba(excel));
     	   cell = row.createCell((short)17);
     	   
     	   cell.setCellStyle(bordeArriba(excel));
     	   contador=contador+1;
     	   lineascuerpo=lineascuerpo+1;
        	row = sheet.createRow((short)contador);
        	cell = row.createCell((short)0);
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalconvenio",W83aClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalconvenio",W83aClsConstantes.CONSTANTE_CASTELLANO));
        	cell = row.createCell((short)9);
        	cell.setCellValue(totalelectores);
        	cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        	cell = row.createCell((short)10);
        	cell.setCellValue(totalvotos);
        	cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        	cell = row.createCell((short)11);
        	cell.setCellValue(totaldelegados);
        	cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        	cell = row.createCell((short)12);
        	cell.setCellValue(calcularporcentaje(totalvotos,totalelectores));
        	cell.setCellStyle(excel.stylePorcentajesDcha);
        	boolean otros=false;
        	int delegados=0;
        	Collections.sort(sindicatossector,comparador);//la ordenamos de mayor a menor
        	for (int i=0;i<sindicatossector.size();i++){
        		valores=((String)sindicatossector.get(i)).split("\\|");
        		if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83aUtilidades.porcentaje(Integer.parseInt(valores[0]),totaldelegados)*100<porcentajeFiltro.floatValue()){//
        			delegados=delegados+Integer.parseInt(valores[0]);//
        			otros=true;
        		}
        		else{
	        		cell = row.createCell((short)13);
	        		cell.setCellStyle(styleCentrado(excel));
	        		if ("-1".equals(valores[2])){//
	        			cell.setCellValue("");
	        		}
	        		else{
	        			if(StringUtils.isNotEmpty(valores[2])){
	        				cell.setCellValue(W83aUtilidades.numero(valores[2]));//
	        			}
	        		}
	            	cell = row.createCell((short)14);
	            	cell2 = row.createCell((short)15);
	            	sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15));//NOPMD
	            	if ("-1".equals(valores[2])){//
	            		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.centralnoespecificada",idioma).toUpperCase());
	        		}else if ("null".equals(valores[1])){
	        			cell.setCellValue("");
	        		}
	        		else{
	        			if(StringUtils.isNotEmpty(valores[1])){
	        				cell.setCellValue(valores[1]);
	        			}
	        		}
	            	cell = row.createCell((short)16);
	            	cell.setCellStyle(styleCentrado(excel));
	            	if(StringUtils.isNotEmpty(valores[0])){
	            		cell.setCellValue(W83aUtilidades.numero(valores[0]));//
	            	}
	            	cell = row.createCell((short)17);
	            	cell.setCellStyle(stylePorcentajesDcha(excel));
	            	cell.setCellValue(calcularporcentaje(Integer.parseInt(valores[0]),totaldelegados));//
	            	contador=contador+1;
	            	lineascuerpo=lineascuerpo+1;
	            	row = sheet.createRow((short)contador); 
        		}
        	}
        	if(otros){
        		//metemos la linea de otros
        		cell2 = row.createCell((short)15);
        		cell = row.createCell((short)14);
            	sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15)); //NOPMD
        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase());
        		
        		cell3 = row.createCell((short)16);
        		cell3.setCellStyle(styleCentrado(excel));
        		cell3.setCellValue(delegados);
        		
        		cell = row.createCell((short)17);
            	cell.setCellValue(W83aUtilidades.porcentaje(delegados,totaldelegados));
            	cell.setCellStyle(stylePorcentajesDcha(excel));
        		
        		contador=contador+1;
        		lineascuerpo=lineascuerpo+1;
            	row = sheet.createRow((short)contador);
        	}
        	
     		if (it.hasNext()){
    	   		int paginas=0;
        		int lineasrestantes=0;
        		int lineasultimapagina=0;
        		 //Paginacin
        		//La primera pgina tiene 40 y el resto 53
        		if (pag==1){
        			if (lineascuerpo<=40){
        				lineasrestantes=40-lineascuerpo;
        			}
        			else{
        				lineascuerpo=lineascuerpo-40;
        				if ((lineascuerpo-1)%53==0){
        					paginas=lineascuerpo/53;
        				}
        				else{
        					paginas=1+(lineascuerpo/53);
        				}
            		    lineasultimapagina=40+(paginas*53);
            		    lineasrestantes=lineasultimapagina-lineascuerpo-40;
        			}
        		}
        		else{
        			if (lineascuerpo<=53){
        				lineasrestantes=53-lineascuerpo;
        			}
        			else{
        				if ((lineascuerpo-1)%53==0){
        					paginas=lineascuerpo/53;
        				}
        				else{
        					paginas=1+(lineascuerpo/53);
        				}
        				lineasultimapagina=paginas*53;
        				lineasrestantes=lineasultimapagina-lineascuerpo;
        			}
        		}
        	   contador=contador+lineasrestantes;
    		}
        }
	   contador=contador+1;
	   row = sheet.createRow((short)contador);
	   cell2 = row.createCell((short)0);
	   cell2.setCellStyle(bordeArriba(excel));
	   cell = row.createCell((short)1);
	   cell.setCellStyle(bordeArriba(excel));
	   cell2 = row.createCell((short)2);
	   
	   cell2.setCellStyle(bordeArriba(excel));
	   cell = row.createCell((short)3);
	   cell.setCellStyle(bordeArriba(excel));
	   cell2 = row.createCell((short)4);
	   
	   cell2.setCellStyle(bordeArriba(excel));
	   cell2 = row.createCell((short)5);
	   cell2.setCellStyle(bordeArriba(excel));
	   cell = row.createCell((short)6);
	   
	   cell.setCellStyle(bordeArriba(excel));
	   cell2 = row.createCell((short)7);
	   cell2.setCellStyle(bordeArriba(excel));
	   cell3 = row.createCell((short)8);
	   
	   cell3.setCellStyle(bordeArriba(excel));
	   cell = row.createCell((short)9);
	   cell.setCellStyle(bordeArriba(excel));
	   cell2 = row.createCell((short)10);
	   
	   cell2.setCellStyle(bordeArriba(excel));
	   cell = row.createCell((short)11);
	   cell.setCellStyle(bordeArriba(excel));
	   cell2 = row.createCell((short)12);
	   
	   cell2.setCellStyle(bordeArriba(excel));
	   cell3 = row.createCell((short)13);
	   cell3.setCellStyle(bordeArriba(excel));
	   cell = row.createCell((short)14);
	   
	   cell.setCellStyle(bordeArriba(excel));
	   cell2 = row.createCell((short)15);
	   cell2.setCellStyle(bordeArriba(excel));
	   cell = row.createCell((short)16);
	   
	   cell.setCellStyle(bordeArriba(excel));
	   cell2 = row.createCell((short)17);
	   cell2.setCellStyle(bordeArriba(excel));
	   
	   contador=contador+1;
       row = sheet.createRow((short)contador);
   	   cell = row.createCell((short)0);
   	   if (!"".equals(resultadoBean.getDescTerritorio())){
			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalterritorio",W83aClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalterritorio",W83aClsConstantes.CONSTANTE_CASTELLANO));
		}
		else{
			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalcomunidad",W83aClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalcomunidad",W83aClsConstantes.CONSTANTE_CASTELLANO));
		}
   	   cell = row.createCell((short)9);
   	   cell.setCellStyle(styleDerechaNumeroFormateado(excel));
   	   cell.setCellValue(totalelectoresterrit);
   	   cell = row.createCell((short)10);
   	   cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	   cell.setCellValue(numvotosterrit);
	   cell = row.createCell((short)11);
	   cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	   cell.setCellValue(totaldelegadosterrit);
	   cell = row.createCell((short)12);
	   cell.setCellStyle(stylePorcentajesDcha(excel));
       cell.setCellValue(calcularporcentaje(numvotosterrit,totalelectoresterrit));
       boolean otros=false;
	 	int delegados=0;
	 	Collections.sort(sindicatossectorterrit,comparador);//la ordenamos de mayor a menor
	 	for (int i=0;i<sindicatossectorterrit.size();i++){
    		valores=((String)sindicatossectorterrit.get(i)).split("\\|");
    		if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83aUtilidades.porcentaje(Integer.parseInt(valores[0]),totaldelegadosterrit)*100<porcentajeFiltro.floatValue()){//
    			delegados=delegados+Integer.parseInt(valores[0]);//
    			otros=true;
    		}
    		else{
	    		cell = row.createCell((short)13);
	    		cell.setCellStyle(styleCentrado(excel));
	    		if ("-1".equals(valores[2])){//
	    			cell.setCellValue("");
	    		}
	    		else{
	    			if(StringUtils.isNotEmpty(valores[2])){
	    				cell.setCellValue(W83aUtilidades.numero(valores[2]));//
	    			}
	    		}
	        	cell = row.createCell((short)14);
	        	cell2 = row.createCell((short)15);
	        	sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15));//NOPMD
	        	if ("-1".equals(valores[2])){//
	        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.centralnoespecificada",idioma).toUpperCase());
	    		}else if ("null".equals(valores[1])){
	    			cell.setCellValue("");
	    		}
	    		else{
	    			if(StringUtils.isNotEmpty(valores[1])){
	    				cell.setCellValue(valores[1]);
	    			}
	    		}
	        	cell = row.createCell((short)16);
	        	cell.setCellStyle(styleCentrado(excel));
	        	if(StringUtils.isNotEmpty(valores[0])){
	        		cell.setCellValue(W83aUtilidades.numero(valores[0]));//
	        	}
	        	cell = row.createCell((short)17);
	        	cell.setCellStyle(stylePorcentajesDcha(excel));
	        	cell.setCellValue(calcularporcentaje(Integer.parseInt(valores[0]),totaldelegadosterrit));//
	        	contador=contador+1;
	        	row = sheet.createRow((short)contador); 
    		}
    	}
	 	if(otros){
    		//metemos la linea de otros
	 		cell2 = row.createCell((short)15);
    		cell = row.createCell((short)14);
        	sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15)); //NOPMD
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase());
    		
    		cell2 = row.createCell((short)16);
    		cell2.setCellStyle(styleCentrado(excel));
    		cell2.setCellValue(delegados);
    		
    		cell = row.createCell((short)17);
        	cell.setCellValue(W83aUtilidades.porcentaje(delegados,totaldelegadosterrit));
        	cell.setCellStyle(stylePorcentajesDcha(excel));
    		
    		contador=contador+1;
        	
        	row = sheet.createRow((short)contador);
    	}
        byte[] bytesExcel = W83aUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoDelegadosPorConvenio.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	private HSSFCellStyle stylePorcentajesDcha(W83aUtilidadesExcel excel){
		return excel.stylePorcentajesDcha;			
		
	}
	
	private float calcularporcentaje(int totalparc,int total){
	
		
		if (total==0){
			Double d = new Double("0");
			return d.floatValue();
		}
		else{
			return((float)totalparc)/(float)total;			
		}
	}
	
	
	
	private HSSFCellStyle styleCentrado(W83aUtilidadesExcel excel){
		return excel.styleCentrado;			
		
	}
	
	private HSSFCellStyle bordeArriba(W83aUtilidadesExcel excel){
		return excel.styleBordeArriba;			
		
	}
	
	private HSSFCellStyle styleTextoImparCentrado(W83aUtilidadesExcel excel){
		return excel.styleTextoImparCentrado;			
		
	}
	

	private HSSFCellStyle styleDerechaNumeroFormateado(W83aUtilidadesExcel excel){
		return excel.styleDerechaNumeroFormateado;			
		
	}
}
